/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.AnalogDeltaTriggerParameter;
import DE.siemens.ad.logo.model.AnalogFilterParameter;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.AstronomicalClockParameter;
import DE.siemens.ad.logo.model.AverageValueParameter;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.ModeUniversal;
import DE.siemens.ad.logo.model.Months;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.Remanence;
import DE.siemens.ad.logo.model.SoftkeyParameter;
import DE.siemens.ad.logo.model.StopWatchParameter;
import DE.siemens.ad.logo.model.TimeBase;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.YearClockParameter;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.lang.reflect.Array;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ParameterItemValueFormatter {
    private static ParameterItemValueFormatter fSingletonInstance;
    public static final String[] DAYS;

    public String formatLogo(ParameterItem parameterItem, Object parameterValue) {
        String formattedString = null;
        if (parameterItem.getParameter() instanceof MessageParameter && parameterItem.getIdentifier().startsWith("Text")) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(parameterItem.getIdentifier()).append(":");
            if (parameterValue != null) {
                MessageParameter.MessageText text = (MessageParameter.MessageText)parameterValue;
                buffer.append(text.getInfoAsString());
            } else {
                buffer.append("Disabled");
            }
            formattedString = buffer.toString();
        } else if (parameterItem.getParameter() instanceof StopWatchParameter && (parameterItem.getIdentifier().equals("CT") || parameterItem.getIdentifier().equals("LT") || parameterItem.getIdentifier().equals("Aq"))) {
            formattedString = Util.addLeadingSpaces(parameterItem.getValue().toString(), parameterItem.getWidth());
        } else if (parameterValue.getClass().isArray()) {
            int length = Array.getLength(parameterValue);
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(parameterValue, i);
                buffer.append(this.formatLogo(parameterItem, arrayElement)).append('\n');
            }
            if (length >= 1) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            formattedString = buffer.toString();
        } else if (parameterValue instanceof TimeUnit) {
            formattedString = ((TimeUnit)parameterValue).getTimeAsString();
        } else if (parameterValue.getClass() == IntValueProperties.class) {
            formattedString = this.getIntValueString(parameterItem, (IntValueProperties)parameterValue);
        } else if (parameterValue instanceof TimeValueProperties) {
            formattedString = ((TimeValueProperties)parameterValue).getCurrentValue().getParameterText();
        } else if (parameterValue.getClass() == Time.class) {
            formattedString = this.getTimeString(parameterItem, (Time)parameterValue);
        } else if (parameterValue.getClass() == Date.class) {
            formattedString = this.getDateString(parameterItem, (Date)parameterValue);
        } else if (parameterValue instanceof ClockHours) {
            formattedString = this.getClockHoursString(parameterItem, (ClockHours)parameterValue);
        } else if (parameterValue instanceof Mode) {
            formattedString = this.getModeString(parameterItem, (Mode)parameterValue);
        } else if (parameterValue instanceof Remanence) {
            formattedString = this.getRemanenceString(parameterItem, (Remanence)parameterValue);
        } else if (parameterValue instanceof SoftkeyParameter.SwitchState) {
            formattedString = ((SoftkeyParameter.SwitchState)parameterValue).toString();
        } else if (parameterValue.getClass() == AnalogValueProperties.class) {
            formattedString = this.getAnalogValueString(parameterItem, (AnalogValueProperties)parameterValue);
        } else if (parameterValue instanceof IntegerOrBlockReference) {
            formattedString = parameterValue instanceof AnalogOrBlockReference ? (((AnalogOrBlockReference)parameterValue).isReference() ? this.getAnalogOrReferenceString(parameterItem, (AnalogOrBlockReference)parameterValue) : this.getAnalogValueString(parameterItem, ((AnalogOrBlockReference)parameterValue).getAnalogValueProperties())) : this.getIntegerOrReferenceString(parameterItem, (IntegerOrBlockReference)parameterValue);
        } else if (parameterValue instanceof MessageLine) {
            formattedString = "'" + ((MessageLine)parameterValue).getParameterText() + "'/";
        } else if (parameterValue instanceof Integer) {
            formattedString = Util.addLeadingSpaces(((Integer)parameterValue).toString(), parameterItem.getMinWidth());
        } else if (parameterValue instanceof DoubleValueProperties) {
            formattedString = this.getDoubleValueString(parameterItem, (DoubleValueProperties)parameterValue);
            if (formattedString.length() < parameterItem.getWidth()) {
                formattedString = Util.addLeadingSpaces(formattedString, parameterItem.getWidth());
            }
        } else if (parameterValue instanceof TimeBase) {
            if (parameterItem.getParameter() instanceof AverageValueParameter) {
                formattedString = Util.addLeadingSpaces(((TimeBase)parameterValue).getTime() + ((TimeBase)parameterValue).getTimeBaseAbbreviation(), parameterItem.getWidth());
            } else if (parameterItem.getParameter() instanceof StopWatchParameter) {
                formattedString = Util.addLeadingSpaces(((TimeBase)parameterValue).getTimeBaseAbbreviation(), parameterItem.getWidth());
            }
        } else if (parameterValue instanceof Boolean) {
            String string = formattedString = (Boolean)parameterValue != false ? "On" : "Off";
        }
        if (formattedString == null) {
            formattedString = parameterValue.toString();
        }
        if (formattedString.length() < parameterItem.getWidth()) {
            formattedString = Util.addTrailingSpaces(formattedString, parameterItem.getWidth());
        }
        if (formattedString == null) {
            throw new IllegalArgumentException("ParameterItemValueFormatter.formatLogo(): No formatter found for type " + parameterValue.getClass());
        }
        return formattedString;
    }

    public String formatUDF(ParameterItem parameterItem, Object parameterValue) {
        String formattedString = null;
        if (parameterItem.getParameter() instanceof MathDetectionParameter) {
            StringBuffer buffer = new StringBuffer();
            MathDetectionParameter mathDetectionParameter = (MathDetectionParameter)parameterItem.getParameter();
            if (mathDetectionParameter.isDetectOverflow() && parameterItem.getIdentifier().equals("OE")) {
                if (mathDetectionParameter.isOverflow() == 1) {
                    buffer.append("Overflow");
                } else {
                    buffer.append("No Error");
                }
            } else if (mathDetectionParameter.isDetectZeroDivision() && parameterItem.getIdentifier().equals("ZE")) {
                if (mathDetectionParameter.isZeroDivision() == 1) {
                    buffer.append("Zero_div");
                } else {
                    buffer.append("No Error");
                }
            }
            formattedString = buffer.toString();
        } else if (parameterItem.getParameter() instanceof StopWatchParameter && (parameterItem.getIdentifier().equals("CT") || parameterItem.getIdentifier().equals("LT") || parameterItem.getIdentifier().equals("Aq"))) {
            formattedString = Util.addLeadingSpaces(parameterItem.getValue().toString(), 5);
        } else if (parameterValue.getClass().isArray()) {
            int length = Array.getLength(parameterValue);
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(parameterValue, i);
                buffer.append(this.formatUDF(parameterItem, arrayElement)).append('\n');
            }
            if (length >= 1) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            formattedString = buffer.toString();
        } else if (parameterValue instanceof TimeUnit) {
            formattedString = ((TimeUnit)parameterValue).getTimeAsString();
        } else if (parameterValue.getClass() == IntValueProperties.class) {
            formattedString = this.getIntValueString(parameterItem, (IntValueProperties)parameterValue);
        } else if (parameterValue instanceof TimeValueProperties) {
            formattedString = ((TimeValueProperties)parameterValue).getCurrentValue().getParameterText();
        } else if (parameterValue.getClass() == Time.class) {
            formattedString = this.getTimeString(parameterItem, (Time)parameterValue);
        } else if (parameterValue.getClass() == Date.class) {
            formattedString = this.getDateString(parameterItem, (Date)parameterValue);
        } else if (parameterValue instanceof ClockHours) {
            formattedString = this.getClockHoursString(parameterItem, (ClockHours)parameterValue);
        } else if (parameterValue instanceof Mode) {
            formattedString = this.getModeString(parameterItem, (Mode)parameterValue);
        } else if (parameterValue instanceof Remanence) {
            formattedString = this.getRemanenceString(parameterItem, (Remanence)parameterValue);
        } else if (parameterValue instanceof SoftkeyParameter.SwitchState) {
            formattedString = ((SoftkeyParameter.SwitchState)parameterValue).toString();
        } else if (parameterValue.getClass() == AnalogValueProperties.class) {
            formattedString = parameterItem.getParameter() instanceof AnalogDeltaTriggerParameter && !parameterItem.getIdentifier().equals("A") ? this.getIntValueString(parameterItem, (AnalogValueProperties)parameterValue) : this.getAnalogValueString(parameterItem, (AnalogValueProperties)parameterValue);
        } else if (parameterValue instanceof IntegerOrBlockReference) {
            formattedString = ((IntegerOrBlockReference)parameterValue).getParameterText();
        } else if (parameterValue instanceof MessageLine) {
            formattedString = "'" + ((MessageLine)parameterValue).getParameterText() + "'/";
        } else if (parameterValue instanceof Integer) {
            formattedString = Util.addLeadingSpaces(((Integer)parameterValue).toString(), parameterItem.getMinWidth());
        } else if (parameterValue instanceof DoubleValueProperties) {
            formattedString = this.getDoubleValueString(parameterItem, (DoubleValueProperties)parameterValue);
            if (formattedString.length() < parameterItem.getWidth()) {
                formattedString = Util.addLeadingSpaces(formattedString, parameterItem.getWidth());
            }
        } else if (parameterValue instanceof TimeBase) {
            if (parameterItem.getParameter() instanceof AverageValueParameter) {
                formattedString = Util.addLeadingSpaces(((TimeBase)parameterValue).getTime() + ((TimeBase)parameterValue).getTimeBaseAbbreviation(), parameterItem.getWidth());
            } else if (parameterItem.getParameter() instanceof StopWatchParameter) {
                formattedString = ((TimeBase)parameterValue).getTimeBaseAbbreviation();
            }
        }
        if (formattedString == null) {
            formattedString = parameterValue.toString();
        }
        if (formattedString.length() < parameterItem.getWidth()) {
            formattedString = Util.addTrailingSpaces(formattedString, parameterItem.getWidth());
        }
        if (formattedString == null) {
            throw new IllegalArgumentException("ParameterItemValueFormatter.formatLogo(): No formatter found for type " + parameterValue.getClass());
        }
        return formattedString;
    }

    private String getDoubleValueString(ParameterItem parameterItem, DoubleValueProperties properties) {
        return properties.toString();
    }

    private String getAnalogOrReferenceString(ParameterItem parameterItem, AnalogOrBlockReference analogOrBlockReference) {
        return Util.addLeadingSpaces(analogOrBlockReference.getParameterText(), parameterItem.getMinWidth());
    }

    public Number getVMValue(ParameterItem item) {
        Number result = null;
        Object parameterValue = item.getValue();
        if (parameterValue.getClass() == ClockHours.class || parameterValue.getClass() == Months.class || parameterValue.getClass() == Hours.class && item.getParameter() instanceof AstronomicalClockParameter) {
            result = Integer.parseInt(((TimeUnit)parameterValue).getBCDString(), 2);
        } else if (parameterValue instanceof TimeUnit) {
            result = ((TimeUnit)parameterValue).getReferencedValue();
        } else if (parameterValue.getClass() == IntValueProperties.class) {
            if (item.getParameter() instanceof AstronomicalClockParameter && item.getIdentifier().equals("TZ")) {
                int val = ((IntValueProperties)parameterValue).getCurrentValue();
                result = Math.abs(val) | (val >= 0 ? 0 : 1) << 15;
            } else {
                result = item.getParameter() instanceof YearClockParameter && (item.getIdentifier().equals("OnY") || item.getIdentifier().equals("OffY")) ? Integer.valueOf(Integer.parseInt(String.valueOf(((IntValueProperties)parameterValue).getCurrentValue() - 2000), 16)) : new Integer(this.getIntValueString(item, (IntValueProperties)parameterValue).trim());
            }
        } else if (parameterValue.getClass() == TimeValueProperties.class) {
            result = ((TimeValueProperties)parameterValue).getCurrentValue().getReferencedValue();
        } else if (parameterValue.getClass() == Time.class) {
            result = new Long(((Time)parameterValue).getTime());
        } else if (parameterValue.getClass() == Date.class) {
            result = new Long(((Date)parameterValue).getTime());
        } else if (parameterValue.getClass() == SoftkeyParameter.SwitchState.class) {
            result = new Integer(((SoftkeyParameter.SwitchState)parameterValue).getState() ? 1 : 0);
        } else if (parameterValue.getClass() == AnalogValueProperties.class) {
            result = new Integer(((AnalogValueProperties)parameterValue).getCurrentValue());
        } else if (parameterValue instanceof IntegerOrBlockReference) {
            result = new Integer(((IntegerOrBlockReference)parameterValue).getValue());
        } else if (parameterValue.getClass() == Integer.class) {
            result = item.getParameter() instanceof AnalogFilterParameter && item.getIdentifier().equals("SN") ? Integer.valueOf(Integer.toBinaryString((Integer)parameterValue).length() - 1) : (Integer)parameterValue;
        } else if (parameterValue.getClass() == Double.class) {
            result = ((Double)parameterValue).intValue();
        } else if (parameterValue.getClass() == DoubleValueProperties.class) {
            result = ((DoubleValueProperties)parameterValue).getCurrentValue() * Math.pow(10.0, ((DoubleValueProperties)parameterValue).getDecimalPointPosition());
        } else if (parameterValue.getClass() == TimeBase.class) {
            result = item.getParameter() instanceof StopWatchParameter ? Integer.valueOf(((TimeBase)parameterValue).getTimeBaseKey()) : Integer.valueOf(((TimeBase)parameterValue).getTime());
        } else if (parameterValue.getClass() == Boolean.class) {
            result = (Boolean)parameterValue != false ? 1 : 0;
        } else if (parameterValue.getClass() == Long.class) {
            result = (long)((Long)parameterValue);
        } else if (parameterValue.getClass() == AstronomicalClockParameter.Theodolite.class) {
            AstronomicalClockParameter.Theodolite tho = (AstronomicalClockParameter.Theodolite)parameterValue;
            result = tho.getDir() << 24 | tho.getDegree() << 16 | tho.getMinute() << 8 | tho.getSecond();
        } else if (parameterValue.getClass() == ModeUniversal.class) {
            int[] days = ((ModeUniversal)parameterValue).getDays();
            int ret = 0;
            for (int i = 0; i < days.length; ++i) {
                ret |= 1 << days[i] - 1;
            }
            result = ret;
        } else if (parameterValue.getClass() == Character.class && item.getIdentifier().equalsIgnoreCase("Dir")) {
            result = String.valueOf(parameterValue).equalsIgnoreCase("+") ? Integer.valueOf(0) : Integer.valueOf(1);
        }
        if (result == null) {
            throw new IllegalArgumentException("ParameterItemValueFormatter.asNumber(): No formatter found for type " + parameterValue.getClass());
        }
        return result;
    }

    private String getAnalogValueString(ParameterItem parameterItem, AnalogValueProperties properties) {
        boolean suppressLeadingZeroes;
        int value = properties.getCurrentValue();
        char sign = value < 0 ? (char)'-' : '+';
        value = Math.abs(value);
        int width = parameterItem.getMinWidth();
        int nachkommastellen = properties.getDecimalPlace();
        String valueString = Integer.toString(value);
        StringBuffer sb = new StringBuffer(valueString);
        boolean bl = suppressLeadingZeroes = !parameterItem.isLeadingZeros();
        if (suppressLeadingZeroes) {
            while (sb.length() <= nachkommastellen) {
                sb.insert(0, '0');
            }
            if (properties.getMin() < 0 && sign == '-') {
                sb.insert(0, sign);
            }
            if (nachkommastellen > 0) {
                sb.insert(sb.length() - nachkommastellen, '.');
            } else {
                sb.append(" ");
            }
            while (sb.length() < width) {
                sb.insert(0, " ");
            }
        } else {
            --width;
            while (sb.length() < width) {
                sb.insert(0, '0');
            }
            if (nachkommastellen > 0) {
                sb.insert(sb.length() - nachkommastellen, '.');
            }
            if (properties.getMin() < 0) {
                sb.insert(0, sign);
            } else {
                sb.insert(0, '0');
            }
        }
        return sb.toString();
    }

    private String getRemanenceString(ParameterItem parameterItem, Remanence remanence) {
        String remString = null;
        remString = remanence.getRemanence() ? "on" : "off";
        return remString;
    }

    private String getIntegerOrReferenceString(ParameterItem parameterItem, IntegerOrBlockReference integerOrBlockReference) {
        return Util.addLeadingSpaces(integerOrBlockReference.getParameterText(), parameterItem.getMinWidth());
    }

    protected String getClockHoursString(ParameterItem parameterItem, ClockHours clockHours) {
        if (clockHours.isInactive()) {
            return "--:--";
        }
        return clockHours.getTimeAsString();
    }

    protected String getDateString(ParameterItem parameterItem, Date date) {
        Calendar calendar = DateFormat.getDateInstance(3, Locale.US).getCalendar();
        calendar.setTime(date);
        StringBuffer dateString = new StringBuffer();
        dateString.append(Util.addLeadingZeros(Integer.toString(calendar.get(1)), 4));
        dateString.append('-');
        dateString.append(Util.addLeadingZeros(Integer.toString(calendar.get(2) + 1), 2));
        dateString.append('-');
        dateString.append(Util.addLeadingZeros(Integer.toString(calendar.get(5)), 2));
        return dateString.toString();
    }

    protected String getIntValueString(ParameterItem parameterItem, IntValueProperties intValueProperties) {
        int value = intValueProperties.getCurrentValue();
        char sign = value < 0 ? (char)'-' : '+';
        value = Math.abs(value);
        String text = Integer.toString(value);
        int length = parameterItem.getMinWidth();
        text = sign == '-' ? (parameterItem.isLeadingZeros() ? sign + Util.addLeadingZeros(text, length - 1) : Util.addLeadingSpaces(sign + text, length)) : (parameterItem.isLeadingZeros() ? Util.addLeadingZeros(text, length) : Util.addLeadingSpaces(text, length));
        return text;
    }

    private String getModeString(ParameterItem parameterItem, Mode mode) {
        return mode.getAbbreviation();
    }

    protected String getTimeString(ParameterItem parameterItem, Time time) {
        Calendar calendar = DateFormat.getDateInstance(3, Locale.US).getCalendar();
        calendar.setTime(time);
        StringBuffer timeString = new StringBuffer();
        timeString.append(DAYS[calendar.get(7) - 1]);
        timeString.append(' ');
        timeString.append(Util.addLeadingZeros(Integer.toString(calendar.get(11)), 2));
        timeString.append(':');
        timeString.append(Util.addLeadingZeros(Integer.toString(calendar.get(12)), 2));
        return timeString.toString();
    }

    public static ParameterItemValueFormatter getInstance() {
        if (fSingletonInstance == null) {
            fSingletonInstance = new ParameterItemValueFormatter();
        }
        return fSingletonInstance;
    }

    public void setValue(ParameterItem parameterItem, int value) {
        Object parameterValue = parameterItem.getValue();
        if (parameterValue instanceof TimeUnit) {
            ((TimeUnit)parameterValue).setTime(0, value);
        } else if (parameterValue.getClass() == IntValueProperties.class) {
            ((IntValueProperties)parameterValue).setCurrentValue(value);
        } else if (parameterValue instanceof TimeValueProperties) {
            ((TimeValueProperties)parameterValue).getCurrentValue().setTime(0, value);
        } else if (parameterValue.getClass() == Date.class) {
            ((Date)parameterValue).setTime(value);
        } else if (parameterValue instanceof SoftkeyParameter.SwitchState) {
            ((SoftkeyParameter.SwitchState)parameterValue).setState(value == 1);
        } else if (parameterValue.getClass() == AnalogValueProperties.class) {
            ((AnalogValueProperties)parameterValue).setCurrentValue(value);
        } else if (parameterValue instanceof IntegerOrBlockReference) {
            ((IntegerOrBlockReference)parameterValue).setIntValue(value);
        } else if (parameterValue instanceof Integer) {
            parameterValue = new Integer(value);
        }
    }

    static {
        DAYS = new String[]{"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"};
    }
}

